﻿Public Class TextRenderer
    Public Class Digits
        Private space As String() = {"000", "000", "000", "000", "000"}
        Private colon As String() = {"000", "010", "000", "010", "000"}

        Private a As String() = {"000", "111", "101", "111", "101"}
        Private p As String() = {"000", "111", "101", "111", "100"}
        Private m As String() = {"000", "101", "111", "101", "101"}

        Private zero As String() = {"111", "101", "101", "101", "111"}
        Private one As String() = {"010", "110", "010", "010", "111"}
        Private two As String() = {"111", "001", "111", "100", "111"}
        Private three As String() = {"111", "001", "111", "001", "111"}
        Private four As String() = {"101", "101", "111", "001", "001"}
        Private five As String() = {"111", "100", "111", "001", "111"}
        Private six As String() = {"111", "100", "111", "101", "111"}
        Private seven As String() = {"111", "001", "001", "001", "001"}
        Private eigth As String() = {"111", "101", "111", "101", "111"}
        Private nine As String() = {"111", "101", "111", "001", "111"}

        Public Function Generate(value As String) As String
            Dim r(value.Length * 3 + value.Length - 1, 5) As String
            Dim v() As String
            Dim offset As Integer = 0

            For i As Integer = 0 To value.Length - 1
                Select Case value.Substring(i, 1)
                    Case "0" : v = zero
                    Case "1" : v = one
                    Case "2" : v = two
                    Case "3" : v = three
                    Case "4" : v = four
                    Case "5" : v = five
                    Case "6" : v = six
                    Case "7" : v = seven
                    Case "8" : v = eigth
                    Case "9" : v = nine
                    Case ":" : v = colon
                    Case " " : v = space
                    Case "a" : v = a
                    Case "p" : v = p
                    Case "m" : v = m
                    Case Else : v = space
                End Select

                For row As Integer = 0 To 4
                    For col As Integer = 0 To 2
                        Select Case v(row).Substring(col, 1)
                            Case "0" : r(col + offset, row) = " "
                            Case "1" : r(col + offset, row) = "*"
                        End Select
                    Next
                Next
                offset += 4
            Next

            Dim s As String = ""
            For row As Integer = 0 To 4
                For col As Integer = 0 To 3 + offset - 4 - 1
                    If r(col, row) = Nothing Then
                        s += " "
                    Else
                        s += r(col, row)
                    End If

                Next
                s += vbCrLf
            Next

            Return s.Substring(0, s.Length - 2)
        End Function
    End Class

    Public Enum RenderModeConstants
        [Erase]
        Draw
        [OR]
        [AND]
        [XOR]
    End Enum

    Public Enum DotTypeConstants
        Light = 0
        Medium = 1
        Dark = 2
        VeryDark = 3
    End Enum

    Public Class Pixel
        Private mDotType As DotTypeConstants = DotTypeConstants.Medium
        Private mColor As ConsoleColor = ConsoleColor.Black
        Private mGlyph As Char

        Private mX As Integer
        Private [mY] As Integer

        Public Sub New(x As Integer, y As Integer)
            mX = x
            [mY] = y
            mDotType = DotTypeConstants.Medium
            mColor = ConsoleColor.Black

            SetGlyph()
        End Sub

        Public ReadOnly Property X As Integer
            Get
                Return mX
            End Get
        End Property

        Public ReadOnly Property Y As Integer
            Get
                Return [mY]
            End Get
        End Property

        Public Property DotType As DotTypeConstants
            Get
                Return mDotType
            End Get
            Set(value As DotTypeConstants)
                If mDotType <> value Then
                    mDotType = value

                    SetGlyph()
                End If
            End Set
        End Property

        Public Property Color As ConsoleColor
            Get
                Return mColor
            End Get
            Set(value As ConsoleColor)
                mColor = value
            End Set
        End Property

        Public ReadOnly Property Glyph(renderMode As RenderModeConstants) As String
            Get
                Select Case renderMode
                    Case RenderModeConstants.Erase
                        Return " "
                    Case Else
                        Return mGlyph
                End Select
            End Get
        End Property

        Public Sub Draw(renderMode As RenderModeConstants, dotType As DotTypeConstants, Optional color As ConsoleColor = ConsoleColor.White)
            Try
                If X >= 0 AndAlso Y >= 0 AndAlso X < Console.WindowWidth AndAlso Y < Console.WindowHeight Then
                    Me.DotType = dotType
                    Me.Color = color

                    Console.ForegroundColor = color
                    Console.SetCursorPosition(X, Y)

                    Select Case renderMode
                        Case RenderModeConstants.Erase
                            Console.Write(" "c)
                        Case RenderModeConstants.Draw
                            Console.Write(mGlyph)
                        Case RenderModeConstants.OR

                    End Select
                End If
            Catch ex As Exception
            End Try
        End Sub

        Private Sub SetGlyph()
            Select Case DotType
                Case DotTypeConstants.Light
                    mGlyph = "·"c
                Case DotTypeConstants.Medium
                    mGlyph = "♦"c
                Case DotTypeConstants.Dark
                    mGlyph = "■"c
                Case DotTypeConstants.VeryDark
                    mGlyph = "█"c
            End Select
        End Sub
    End Class

    Private pixels(,) As Pixel

    Private digitGenerator As Digits
    Private mAspectRatio As Single = 1
    Private mCompensateAspectRatio As Boolean = False

    Private Const Rad2Deg As Double = 180 / Math.PI
    Private Const Deg2Rad As Double = 1 / Rad2Deg

    Public Sub New()
        digitGenerator = New Digits()

        ReDim pixels(Console.WindowWidth, Console.WindowHeight)
        For x As Integer = 0 To Console.WindowWidth - 1
            For y As Integer = 0 To Console.WindowHeight - 1
                pixels(x, y) = New Pixel(x, y)
            Next
        Next
    End Sub

    Public Property AspectRatio() As Single
        Get
            Return mAspectRatio
        End Get
        Set(value As Single)
            mAspectRatio = value
        End Set
    End Property

    Public Property CompensateAspectRatio() As Boolean
        Get
            Return mCompensateAspectRatio
        End Get
        Set(ByVal value As Boolean)
            mCompensateAspectRatio = value
        End Set
    End Property

    Public Function ReadPixel(x As Integer, y As Integer) As Pixel
        Return pixels(x, y)
    End Function

    Public Sub DrawLine(x As Integer, y As Integer, length As Integer, angle As Integer, renderMode As RenderModeConstants, dotType As DotTypeConstants, Optional color As ConsoleColor = ConsoleColor.White)
        Dim px As Integer
        Dim py As Integer

        For radius As Integer = 0 To length
            px = CInt(radius * Math.Cos(angle * Deg2Rad) + x)
            py = CInt(radius * Math.Sin(-angle * Deg2Rad) + y)

            DrawPixel(px, py, renderMode, dotType, color)
        Next
    End Sub

    Public Sub DrawCircle(x As Integer, y As Integer, radius As Integer, renderMode As RenderModeConstants, dotType As DotTypeConstants, Optional color As ConsoleColor = ConsoleColor.White)
        Dim px As Integer
        Dim py As Integer

        For angle As Integer = 0 To 360
            px = CInt(radius * Math.Cos(angle * Deg2Rad) + x)
            py = CInt(radius * Math.Sin(-angle * Deg2Rad) + y)

            DrawPixel(px, py, renderMode, dotType, color)
        Next
    End Sub

    Public Sub DrawText(text As String, x As Integer, y As Integer, renderMode As RenderModeConstants, dotType As DotTypeConstants, Optional color As ConsoleColor = ConsoleColor.White)
        Dim lines() As String = digitGenerator.Generate(text).Split(New String() {vbCrLf}, StringSplitOptions.None)

        For i As Integer = 0 To lines.Length - 1
            For c As Integer = 0 To lines(i).Length - 1
                If lines(i).Substring(c, 1) = " " Then Continue For
                Select Case renderMode
                    Case RenderModeConstants.Draw
                        DrawPixel(x + c, y, renderMode, dotType, color)
                    Case RenderModeConstants.Erase
                        DrawPixel(x + c, y, renderMode, dotType)
                End Select
            Next
            y += 1
        Next
    End Sub

    Public Sub DrawPixel(x As Integer, y As Integer, renderMode As RenderModeConstants, dotType As DotTypeConstants, Optional color As ConsoleColor = ConsoleColor.White)
        If mAspectRatio = 1 Then
            pixels(CInt(x * mAspectRatio), y).Draw(renderMode, dotType, color)
        Else
            If mAspectRatio > 1 Then
                If mCompensateAspectRatio Then
                    For xi As Integer = CInt(x * mAspectRatio) To CInt(x * mAspectRatio + mAspectRatio)
                        pixels(xi, y).Draw(renderMode, dotType, color)
                    Next
                Else
                    pixels(CInt(x * mAspectRatio), y).Draw(renderMode, dotType, color)
                End If
            Else
                If mCompensateAspectRatio Then
                    For yi As Integer = CInt(y * mAspectRatio) To CInt(y * mAspectRatio + mAspectRatio)
                        pixels(x, yi).Draw(renderMode, dotType, color)
                    Next
                Else
                    pixels(x, CInt(y * mAspectRatio)).Draw(renderMode, dotType, color)
                End If
            End If
        End If
    End Sub
End Class
