﻿Imports x8086NetEmu

Public Class FormConsole
    Private mEmulator As x8086

    Private Sub FormConsole_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        RemoveHandler x8086.Output, AddressOf Output
    End Sub

    Private Sub FormConsole_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        RichTextBoxConsole.Text = ""
    End Sub

    Public Property Emulator As x8086
        Get
            Return mEmulator
        End Get
        Set(value As x8086)
            mEmulator = value

            AddHandler x8086.Output, AddressOf Output
        End Set
    End Property

    Private Sub Output(message As String)
        Try
            Me.Invoke(New MethodInvoker(Sub() RichTextBoxConsole.AppendText(MilTime + "  " + message + vbCrLf)))
        Catch
        End Try
    End Sub

    Private ReadOnly Property MilTime As String
        Get
            Return String.Format("{0:00}:{1:00}:{2:00}:{3:000}", Now.Hour, Now.Minute, Now.Second, Now.Millisecond)
        End Get
    End Property
End Class