﻿Partial Public Class x8086
    Private Sub OpCodeNotImplemented(opCode As Byte, Optional comment As String = "")
        ThrowException(String.Format("OpCode '{0}' at {1} Not Implemented{2}", Decode(Me, True).Mnemonic.Replace("h:", ""),
                                                                                        mRegisters.PointerAddressToString().Replace("h", ""),
                                                                                        If(comment = "", "", ": " + comment)))
    End Sub

    Private Sub InterruptNotImplemented(intNum As Integer)
        ThrowException("Interrupt 0x" + intNum.ToHex(DataSize.Byte) + " not implemented")
    End Sub

    Private Sub InterruptModeNotImplemented(intNum As Integer, mode As Integer)
        ThrowException("Interrupt 0x" + intNum.ToHex(DataSize.Byte) + " mode 0x" + mode.ToHex(DataSize.Byte) + " not implemented")
    End Sub

    Private Sub InterruptSubModeNotImplemented(intNum As Integer, mode As Integer, subMode As Integer)
        ThrowException("Interrupt 0x" + intNum.ToHex(DataSize.Byte) + " mode 0x" + mode.ToHex(DataSize.Byte) + "/0x" + subMode.ToHex(DataSize.Byte) + " not implemented")
    End Sub

    Private Sub VGAAdapterNotFound()
        ThrowException("VGA Adapter Not Found")
    End Sub

    Private Sub KeyboardAdapterNotFound()
        ThrowException("Keyboard Adapter Not Found")
    End Sub

    Private Sub DiskAdapterNotFound()
        ThrowException("Disk Adapter Not Found")
    End Sub

    Private Sub SystemReboot()
        ThrowException("System Reboot")
    End Sub

    Private Sub SystemHalted()
        ThrowException("System Halted")
        mIsHalted = True
    End Sub

    Private Sub NoIOPort(port As Integer)
        'ThrowException("No IOPort responding at " + port.ToHex(DataSize.Word) + " called at " + mRegisters.CS.ToHex(DataSize.Word).TrimEnd("h") + ":" + mRegisters.IP.ToHex(DataSize.Word).TrimEnd("h"))
    End Sub

    Public Sub RaiseException(message As String)
        ThrowException(message)
    End Sub

    Private Sub ThrowException(message As String)
        If mEnableExceptions Then
            Throw New Exception(message)
        Else
            x8086.Notify(message)
            RaiseEvent Error(message)
        End If
    End Sub

    Public Shared Sub Notify(message As String, ParamArray arg() As Object)
        message = String.Format(message, arg)

        'Debug.WriteLine(message)
        'Console.WriteLine(message)

        RaiseEvent Output(message)
    End Sub
End Class
