﻿Imports x8086NetEmu

Module MainModule
    Private cpu As x8086

    Sub Main()
        cpu = New x8086()

        Dim fc = New FloppyControllerAdapter(cpu)

        cpu.Adapters.Add(fc)
        cpu.Adapters.Add(New CGAConsole(cpu))
        cpu.Adapters.Add(New KeyboardAdapter(cpu))
#If Win32 Then
        cpu.Adapters.Add(New SpeakerAdpater(cpu))
#End If

        cpu.ClockFrequency = x8086.BaseClock * 8

        fc.DiskImage(128) = New DiskImage("disks\hd0.img", , True)
        fc.DiskImage(129) = New DiskImage("disks\hd1.img", , True)
        fc.DiskImage(1) = New DiskImage("disks\Dos4.01.img", , False)

        cpu.Run(False)
    End Sub
End Module
