﻿Imports System.Runtime.CompilerServices
Imports x8086NetEmu

Module Extensions
    <Extension()>
    Public Function LowByte(value As Integer) As Byte
        Return value And &HFF
    End Function

    <Extension()>
    Public Function HighByte(value As Integer) As Byte
        Return value >> 8
    End Function

    <Extension()>
    Public Function LowNib(value As Byte) As Byte
        Return value And &HF
    End Function

    <Extension()>
    Public Function HighNib(value As Byte) As Byte
        Return value >> 4
    End Function

    <Extension()>
    Public Function ToBinary(value As Byte) As String
        Return Convert.ToString(value, 2).PadLeft(8, "0")
    End Function

    <Extension()>
    Public Function ToBinary(value As Integer) As String
        Return Convert.ToString(value, 2).PadLeft(16, "0")
    End Function

    <Extension()>
    Public Function ToBinary(value As x8086.GPRegisters.RegistersTypes) As String
        Return Convert.ToString(value, 2)
    End Function

    <Extension()>
    Public Function ToHex(value As Byte) As String
        Return value.ToString("X").PadLeft(2, "0") + "h"
    End Function

    <Extension()>
    Public Function ToHex(value As Integer, size As x8086.DataSize) As String
        If size = x8086.DataSize.Byte Then
            Return value.ToString("X").PadLeft(2, "0") + "h"
        Else
            Return value.ToString("X").PadLeft(4, "0") + "h"
        End If
    End Function

    <Extension()>
    Public Function ToHex(value As Long, size As x8086.DataSize) As String
        Select Case size
            Case x8086.DataSize.Byte
                Return value.ToString("X").PadLeft(2, "0") + "h"
            Case x8086.DataSize.Word
                Return value.ToString("X").PadLeft(4, "0") + "h"
            Case x8086.DataSize.DWord
                Return value.ToString("X").PadLeft(8, "0") + "h"
            Case Else
                Return ""
        End Select
    End Function
End Module
