﻿Imports System.Runtime.InteropServices
Imports System.Text

Public Class FontAPI
    <DllImport("gdi32.dll", CharSet:=CharSet.Auto)>
    Public Shared Function GetTextMetrics(hdc As IntPtr, ByRef lptm As TEXTMETRIC) As Boolean
    End Function

    <DllImport("Gdi32.dll", CharSet:=CharSet.Unicode)>
    Public Shared Function SelectObject(hdc As IntPtr, hgdiobj As IntPtr) As IntPtr
    End Function

    <DllImport("Gdi32.dll", CharSet:=CharSet.Unicode)>
    Public Shared Function DeleteObject(hdc As IntPtr) As Boolean
    End Function

    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Auto)>
    Public Structure TEXTMETRIC
        Public tmHeight As Integer
        Public tmAscent As Integer
        Public tmDescent As Integer
        Public tmInternalLeading As Integer
        Public tmExternalLeading As Integer
        Public tmAveCharWidth As Integer
        Public tmMaxCharWidth As Integer
        Public tmWeight As Integer
        Public tmOverhang As Integer
        Public tmDigitizedAspectX As Integer
        Public tmDigitizedAspectY As Integer
        Public tmFirstChar As Char
        Public tmLastChar As Char
        Public tmDefaultChar As Char
        Public tmBreakChar As Char
        Public tmItalic As Byte
        Public tmUnderlined As Byte
        Public tmStruckOut As Byte
        Public tmPitchAndFamily As Byte
        Public tmCharSet As Byte
    End Structure

    Public Shared Function GetTextMetrics(graphics As Graphics, font As Font) As TEXTMETRIC
        Dim hDC As IntPtr = graphics.GetHdc()
        Dim textMetric As TEXTMETRIC
        Dim hFont As IntPtr = font.ToHfont()
        Try
            Dim hFontPreviouse As IntPtr = SelectObject(hDC, hFont)
            Dim result As Boolean = GetTextMetrics(hDC, textMetric)
            SelectObject(hDC, hFontPreviouse)
        Finally
            DeleteObject(hFont)
            graphics.ReleaseHdc(hDC)
        End Try

        Return textMetric
    End Function

    Public Enum FontWeight As Integer
        FW_DONTCARE = 0
        FW_THIN = 100
        FW_EXTRALIGHT = 200
        FW_LIGHT = 300
        FW_NORMAL = 400
        FW_MEDIUM = 500
        FW_SEMIBOLD = 600
        FW_BOLD = 700
        FW_EXTRABOLD = 800
        FW_HEAVY = 900
    End Enum

    Public Enum FontCharSet As Byte
        ANSI_CHARSET = 0
        DEFAULT_CHARSET = 1
        SYMBOL_CHARSET = 2
        SHIFTJIS_CHARSET = 128
        HANGEUL_CHARSET = 129
        HANGUL_CHARSET = 129
        GB2312_CHARSET = 134
        CHINESEBIG5_CHARSET = 136
        OEM_CHARSET = 255
        JOHAB_CHARSET = 130
        HEBREW_CHARSET = 177
        ARABIC_CHARSET = 178
        GREEK_CHARSET = 161
        TURKISH_CHARSET = 162
        VIETNAMESE_CHARSET = 163
        THAI_CHARSET = 222
        EASTEUROPE_CHARSET = 238
        RUSSIAN_CHARSET = 204
        MAC_CHARSET = 77
        BALTIC_CHARSET = 186
    End Enum

    Public Enum FontPrecision As Byte
        OUT_DEFAULT_PRECIS = 0
        OUT_STRING_PRECIS = 1
        OUT_CHARACTER_PRECIS = 2
        OUT_STROKE_PRECIS = 3
        OUT_TT_PRECIS = 4
        OUT_DEVICE_PRECIS = 5
        OUT_RASTER_PRECIS = 6
        OUT_TT_ONLY_PRECIS = 7
        OUT_OUTLINE_PRECIS = 8
        OUT_SCREEN_OUTLINE_PRECIS = 9
        OUT_PS_ONLY_PRECIS = 10
    End Enum

    Public Enum FontClipPrecision As Byte
        CLIP_DEFAULT_PRECIS = 0
        CLIP_CHARACTER_PRECIS = 1
        CLIP_STROKE_PRECIS = 2
        CLIP_MASK = &HF
        CLIP_LH_ANGLES = (1 << 4)
        CLIP_TT_ALWAYS = (2 << 4)
        CLIP_DFA_DISABLE = (4 << 4)
        CLIP_EMBEDDED = (8 << 4)
    End Enum

    Public Enum FontQuality As Byte
        DEFAULT_QUALITY = 0
        DRAFT_QUALITY = 1
        PROOF_QUALITY = 2
        NONANTIALIASED_QUALITY = 3
        ANTIALIASED_QUALITY = 4
        CLEARTYPE_QUALITY = 5
        CLEARTYPE_NATURAL_QUALITY = 6
    End Enum

    Public Enum FontPitchAndFamily As Byte
        DEFAULT_PITCH = 0
        FIXED_PITCH = 1
        VARIABLE_PITCH = 2
        FF_DONTCARE = (0 << 4)
        FF_ROMAN = (1 << 4)
        FF_SWISS = (2 << 4)
        FF_MODERN = (3 << 4)
        FF_SCRIPT = (4 << 4)
        FF_DECORATIVE = (5 << 4)
    End Enum

    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Auto)> _
    Public Class LOGFONT
        Public lfHeight As Integer
        Public lfWidth As Integer
        Public lfEscapement As Integer
        Public lfOrientation As Integer
        Public lfWeight As FontWeight
        <MarshalAs(UnmanagedType.U1)> _
        Public lfItalic As Boolean
        <MarshalAs(UnmanagedType.U1)> _
        Public lfUnderline As Boolean
        <MarshalAs(UnmanagedType.U1)> _
        Public lfStrikeOut As Boolean
        Public lfCharSet As FontCharSet
        Public lfOutPrecision As FontPrecision
        Public lfClipPrecision As FontClipPrecision
        Public lfQuality As FontQuality
        Public lfPitchAndFamily As FontPitchAndFamily
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> _
        Public lfFaceName As String

        Public Overrides Function ToString() As String
            Dim sb As New StringBuilder()
            sb.Append("LOGFONT" & vbLf)
            sb.AppendFormat("   lfHeight: {0}" & vbLf, lfHeight)
            sb.AppendFormat("   lfWidth: {0}" & vbLf, lfWidth)
            sb.AppendFormat("   lfEscapement: {0}" & vbLf, lfEscapement)
            sb.AppendFormat("   lfOrientation: {0}" & vbLf, lfOrientation)
            sb.AppendFormat("   lfWeight: {0}" & vbLf, lfWeight)
            sb.AppendFormat("   lfItalic: {0}" & vbLf, lfItalic)
            sb.AppendFormat("   lfUnderline: {0}" & vbLf, lfUnderline)
            sb.AppendFormat("   lfStrikeOut: {0}" & vbLf, lfStrikeOut)
            sb.AppendFormat("   lfCharSet: {0}" & vbLf, lfCharSet)
            sb.AppendFormat("   lfOutPrecision: {0}" & vbLf, lfOutPrecision)
            sb.AppendFormat("   lfClipPrecision: {0}" & vbLf, lfClipPrecision)
            sb.AppendFormat("   lfQuality: {0}" & vbLf, lfQuality)
            sb.AppendFormat("   lfPitchAndFamily: {0}" & vbLf, lfPitchAndFamily)
            sb.AppendFormat("   lfFaceName: {0}" & vbLf, lfFaceName)

            Return sb.ToString()
        End Function
    End Class
End Class
