﻿Module TestModule
    Sub Main()
        Console.WriteLine("-- Simple initialization of Binary variables")
        Dim n1 As Binary = "100101000"
        Dim n2 As Binary = 129

        Console.WriteLine("n1 = {0} ({1})", n1, n1.ToLong())
        Console.WriteLine("n2 = {0} ({1})", n2, n2.ToLong())

        Console.WriteLine()
        Console.WriteLine("-- Using a Binary variable in a For/Next")
        For i As Binary = 0 To 10
            Console.WriteLine(i.ToLong().ToString().PadLeft(3) + ": " + i.ToString())
        Next

        Console.WriteLine()
        Console.WriteLine("-- Basic arithmetic and logic operations")
        n1 = Binary.From("0110")
        n2 = Binary.From(6)
        Console.WriteLine("n1       = " + n1.ToString())
        Console.WriteLine("n1 << 1  = " + (n1 << 1).ToString())
        Console.WriteLine("n1 >> 1  = " + (n1 >> 1).ToString())
        Console.WriteLine("n1 << n2 = " + (n1 << n2).ToString())

        Console.WriteLine()
        Console.WriteLine("-- Conversions")
        Console.WriteLine("n1 ^ n2 = " + (n1 ^ n2).ToHex() + " as HEX")
        Console.WriteLine("(n1 ^ n2) / 3 + 11 = " + ((n1 ^ n2) / 3 + 11).ToOctal() + " as OCT")

        Console.WriteLine()
        Console.WriteLine("-- Auto base detection")
        n1 = "212F0"
        Console.WriteLine(n1.ToHex() + " = " + n1.ToString())

        Console.WriteLine()
        Console.WriteLine("-- Same digits, different bases")
        Console.WriteLine("1101d = " + Binary.From("1101d").ToString())
        Console.WriteLine("1101b = " + Binary.From("1101b").ToString())
        Console.WriteLine("1101h = " + Binary.From("1101h").ToString())
        Console.WriteLine("1101o = " + Binary.From("1101o").ToString())

        n1 = Long.MaxValue
        Console.WriteLine()
        Console.WriteLine("-- A large number!")
        Console.WriteLine("n1 = {0:N0} as decimal", n1.ToLong())
        Console.WriteLine("n1 = {0} as HEX", n1.ToHex())
        Console.WriteLine("n1 = {0} as OCT", n1.ToOctal())

        Console.ReadKey()
    End Sub
End Module
