﻿Imports Vlc.DotNet.Core

Public Class frmMain
    Private captions As List(Of Caption) = New List(Of Caption)
    Private mMediaIsValid As Boolean = False
    Private media As Vlc.DotNet.Core.Medias.PathMedia
    Private videoFPS As Single
    Private captionEditor As frmEditCaption
    Private isUpdatingUI As Boolean
    Private ignoreListViewSelectionEvent As Boolean
    Private Enum SubsFormats
        SRT
        [SUB]
        Unknown
    End Enum
    Private subsFormat As SubsFormats = SubsFormats.Unknown

#Region "Controls Events"
    Private Sub frmMain_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        SetUIState(False)
    End Sub

    Private Sub SearchCaption(sender As System.Object, e As System.EventArgs) Handles txtSearchOriginal.TextChanged, txtSearchOffsetted.TextChanged, btnSearchOriginalDown.Click, btnSearchOffsettedDown.Click
        Dim lv As ListView = Nothing
        Dim tb As TextBox = Nothing
        Dim offset As Integer = 0

        If TypeOf sender Is Button Then
            offset = 1
            If CType(sender, Button).Name.Contains("Original") Then
                lv = lvOriginal
                tb = txtSearchOriginal
            Else
                lv = lvOffsetted
                tb = txtSearchOffsetted
            End If
        Else
            tb = CType(sender, TextBox)
            If tb.Name.Contains("Original") Then
                lv = lvOriginal
            Else
                lv = lvOffsetted
            End If
        End If

        tb.BackColor = Color.FromKnownColor(KnownColor.Window)
        tb.ForeColor = Color.FromKnownColor(KnownColor.WindowText)

        If tb.Text = "" Then Exit Sub

        Dim startIndex As Integer = 0
        If lv.SelectedItems.Count > 0 Then
            startIndex = lv.SelectedIndices(0) + offset
            If startIndex = lv.Items.Count Then startIndex = 0
        End If

        Dim match As ListViewItem = Nothing
        If lv.Items.Count > 0 Then
            Do
                match = lv.FindItemWithText(tb.Text, True, startIndex)
                If match IsNot Nothing OrElse startIndex = 0 Then Exit Do
                startIndex = 0
            Loop
        End If

        If match Is Nothing Then
            tb.BackColor = Color.DarkRed
            tb.ForeColor = Color.White
        Else
            match.Selected = True
            match.EnsureVisible()
        End If
    End Sub

    Private Sub frmMain_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim tmpFile As String = GetTempFile()

        If vlcCtrl.IsPlaying Then vlcCtrl.Stop()

        If IO.File.Exists(tmpFile) Then
            Select Case MsgBox("You have unsaved changes." + vbCrLf + "Would you like to apply them now?",
                               MsgBoxStyle.Question Or MsgBoxStyle.YesNoCancel)
                Case MsgBoxResult.No
                    UnloadVLCMedia()
                    IO.File.Delete(tmpFile)
                Case MsgBoxResult.Yes
                    SaveOffsettedSubtitles(True)
                Case MsgBoxResult.Cancel
                    e.Cancel = True
            End Select
        End If
    End Sub

    Private Sub btnBrowseSubtitlesFile_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowseSubtitlesFile.Click
        Using dlg = New OpenFileDialog()
            dlg.Filter = "Subtitles File (*.srt;*.sub)|*.srt;*.sub"
            dlg.Title = "Select Subtitles File"
            If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
                txtSubtitlesFile.Text = dlg.FileName
                LoadSubtitles(txtSubtitlesFile.Text)
            End If
        End Using
    End Sub

    Private Sub btnBrowseVideoFile_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowseVideoFile.Click
        Using dlg = New OpenFileDialog()
            dlg.Filter = "Video Files|*.avi;*.mpg;*.mp4;*.mkv|All Files|*.*"
            dlg.Title = "Select Video File"
            If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
                txtVideoFile.Text = dlg.FileName
                LoadVideo(dlg.FileName)
            End If
        End Using
    End Sub

    Private Sub btnClose_Click(sender As System.Object, e As System.EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub btnSave_Click(sender As System.Object, e As System.EventArgs) Handles btnSave.Click
        Me.Enabled = False
        SaveOffsettedSubtitles(True)
        Me.Enabled = True
    End Sub

    Private Sub lvOffsetted_DoubleClick(sender As Object, e As System.EventArgs) Handles lvOffsetted.DoubleClick
        EditCaption(True)
    End Sub

    Private Sub lvOffsetted_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles lvOffsetted.SelectedIndexChanged
        If ignoreListViewSelectionEvent Then Exit Sub

        Dim c As Caption = GetSelectedCaption()

        If c IsNot Nothing Then
            If mMediaIsValid Then
                VideoPosition = c.FromTimeOffsetted.TotalMilliseconds
                UpdatePositionUI(vlcCtrl.Position)
                If vlcCtrl.IsPlaying Then sbCtrl.CenterPosition(False)
            Else
                sbCtrl.Position = c.FromTimeOffsetted
                sbCtrl.CenterPosition(False)
            End If
        End If

        EditCaption()
    End Sub

    Private Sub vlcCtrl_PositionChanged(sender As Vlc.DotNet.Forms.VlcControl, e As Vlc.DotNet.Core.VlcEventArgs(Of Single)) Handles vlcCtrl.PositionChanged
        UpdatePositionUI(e.Data)

        Dim captionAtPosition = sbCtrl.GetCaptionAtPosition()
        If captionAtPosition IsNot Nothing Then
            ignoreListViewSelectionEvent = True
            SelectCaption(captionAtPosition)
            ignoreListViewSelectionEvent = False
        End If
    End Sub

    Private Sub tbPosition_ValueChanged(sender As Object, e As System.EventArgs) Handles tbPosition.ValueChanged
        If isUpdatingUI Then Exit Sub
        vlcCtrl.Position = tbPosition.Value / 1000000
        UpdatePositionUI(vlcCtrl.Position)
    End Sub

    Private Sub btnPlay_Click(sender As System.Object, e As System.EventArgs) Handles btnPlay.Click
        If vlcCtrl.IsPlaying Then
            vlcCtrl.Pause()
        Else
            vlcCtrl.Play()
        End If
    End Sub

    Private Sub btnPlay_EnabledChanged(sender As Object, e As System.EventArgs) Handles btnPlay.EnabledChanged
        If btnPlay.Enabled Then
            btnPlay.Image = My.Resources.playpause_on
        Else
            btnPlay.Image = My.Resources.playpause_off
        End If
    End Sub

    Private Sub btnPlay_MouseDown(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles btnPlay.MouseDown
        If btnPlay.Enabled Then btnPlay.Image = My.Resources.playpause_on_down
    End Sub

    Private Sub btnPlay_MouseEnter(sender As Object, e As System.EventArgs) Handles btnPlay.MouseEnter
        If btnPlay.Enabled Then btnPlay.Image = My.Resources.playpause_on_over
    End Sub

    Private Sub btnPlay_MouseLeave(sender As Object, e As System.EventArgs) Handles btnPlay.MouseLeave
        If btnPlay.Enabled Then btnPlay.Image = My.Resources.playpause_on
    End Sub

    Private Sub btnPlay_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles btnPlay.MouseUp
        If btnPlay.Enabled Then btnPlay.Image = My.Resources.playpause_on
    End Sub

    Private Sub cmbLanguages_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbLanguages.SelectedIndexChanged
        vlcCtrl.AudioProperties.Track = CInt(cmbLanguages.SelectedIndex + 1)
    End Sub

    Private Sub btnDeleteCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnDeleteCaption.Click
        If lvOffsetted.SelectedItems.Count = 0 Then Exit Sub

        Dim c = captions(lvOffsetted.SelectedIndices(0))
        captions.Remove(c)
        lvOffsetted.Items.Remove(lvOffsetted.SelectedItems(0))

        For i As Integer = c.Index - 1 To captions.Count - 1
            captions(i).Index -= 1
        Next
        SaveOffsettedSubtitles(False)
    End Sub

    Private Sub btnEditCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnEditCaption.Click
        If lvOffsetted.SelectedItems.Count = 0 Then Exit Sub

        EditCaption(True)
    End Sub

    Private Sub sbCtrl_CaptionsChanged(captions As System.Collections.Generic.List(Of Caption)) Handles sbCtrl.CaptionsChanged
        UpdateCaptions(captions)
    End Sub

    Private Sub sbCtrl_CaptionSelected(caption As Caption, changed As Boolean) Handles sbCtrl.CaptionSelected
        SelectCaption(caption)
        If changed Then SaveOffsettedSubtitles(False)
    End Sub

    Private Sub sbCtrl_PositionChanged(position As System.TimeSpan, caption As Caption) Handles sbCtrl.PositionChanged
        If mMediaIsValid AndAlso caption Is Nothing Then
            tbPosition.Value = position.TotalMilliseconds / media.Duration.TotalMilliseconds * 1000000
        End If
    End Sub

    Private Sub btnAddCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnAddCaption.Click
        AddCaption()
    End Sub

    Private Sub btnZoomIn_Click(sender As System.Object, e As System.EventArgs) Handles btnZoomIn.Click
        sbCtrl.ZoomFactor += 1
    End Sub

    Private Sub btnZoomOut_Click(sender As System.Object, e As System.EventArgs) Handles btnZoomOut.Click
        sbCtrl.ZoomFactor -= 1
    End Sub

    Private Sub chkRippleEdits_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkRippleEdits.CheckedChanged
        Select Case chkRippleEdits.Checked
            Case True
                chkRippleEdits.Image = My.Resources.lock
            Case False
                chkRippleEdits.Image = My.Resources.lock_open
        End Select
        sbCtrl.RippleEdits = chkRippleEdits.Checked
    End Sub
#End Region

    Private Sub TryAutoLoadVideoFile(subtitlesFileName As String)
        Dim subsFile = New IO.FileInfo(subtitlesFileName)
        Dim subsFileName = subsFile.Name.Replace(subsFile.Extension, "")

        Dim validFileTypes = {".avi", ".mpg", ".mp4", ".mkv"}
        For Each file In subsFile.Directory.GetFiles()
            If validFileTypes.Contains(file.Extension) Then
                Dim videoFileName = file.Name.Replace(file.Extension, "")

                If videoFileName.Length <= subsFileName.Length AndAlso
                    subsFileName.Substring(0, videoFileName.Length) = videoFileName Then
                    txtVideoFile.Text = file.FullName
                    LoadVideo(file.FullName)
                    Exit For
                End If
            End If
        Next
    End Sub

    ' http://en.wikipedia.org/wiki/WHATWG
    Private Sub LoadSubtitles(fileName As String)
        captions.Clear()
        lvOriginal.Items.Clear()
        lvOffsetted.Items.Clear()
        sbCtrl.SetCaptions(Nothing, True)

        SetUIState(False)

        TryAutoLoadVideoFile(fileName)

        Try
            If fileName.ToLower().EndsWith(".srt") Then
                LoadSRTSubTitles(IO.File.ReadAllLines(fileName, System.Text.Encoding.UTF7))
                subsFormat = SubsFormats.SRT
            ElseIf fileName.ToLower().EndsWith(".sub") Then
                If mMediaIsValid Then
                    LoadSUBSubTitles(IO.File.ReadAllLines(fileName, System.Text.Encoding.UTF7))
                    subsFormat = SubsFormats.SUB
                Else
                    Throw New Exception("Please load a valid video file before loading subtitles of the .sub format")
                End If
            Else
                Throw New Exception("Unsupported subtitles file format")
            End If
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical Or MsgBoxStyle.OkOnly)
            subsFormat = SubsFormats.Unknown
            Exit Sub
        End Try

        lvOriginal.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
        lvOffsetted.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)

        SetUIState(True)

        vlcCtrl.VideoProperties.SetSubtitleFile(txtSubtitlesFile.Text)
        EditCaption()

        sbCtrl.SetCaptions(captions, True)
    End Sub

    Private Sub LoadSUBSubTitles(lines() As String)
        Dim index As Integer = 0
        videoFPS = 23.976215

        If vlcCtrl.Media IsNot Nothing Then videoFPS = vlcCtrl.FPS

        For i As Integer = 0 To lines.Count - 1
            If Not lines(i).Contains("{") Then Continue For
            index += 1

            Dim startTime As TimeSpan = TimeSpan.FromMilliseconds(1000 * Integer.Parse(lines(i).Split("{"c)(1).TrimEnd("}")) / videoFPS)
            Dim endTime As TimeSpan = TimeSpan.FromMilliseconds(1000 * Integer.Parse(lines(i).Split("{"c)(2).Split("}")(0)) / videoFPS)
            Dim text As String = lines(i).Split("}")(2).Replace("|", vbCrLf)

            Dim c As Caption = New Caption(index,
                                        startTime,
                                        endTime,
                                        text)

            captions.Add(c)

            UpdateListViewCaption(lvOriginal, c)
            UpdateListViewCaption(lvOffsetted, c)
        Next
    End Sub

    Private Sub LoadSRTSubTitles(lines() As String)
        Dim index As Integer = 0

        For i As Integer = 0 To lines.Count - 1
            Do While i < lines.Count AndAlso lines(i) = ""
                i += 1
            Loop
            If i = lines.Count Then Exit For
            If lines(i + 1) = "" Then Continue For

            index += 1
            Dim startTime As String = lines(i + 1).Split(" "c)(0)
            Dim endTime As String = lines(i + 1).Split(" "c)(2)

            Dim text As String = ""
            i += 2
            Do While i < lines.Count AndAlso lines(i) <> ""
                text += lines(i) + vbCrLf
                i += 1
            Loop
            If text <> "" Then text = text.Substring(0, text.Length - 2)

            Dim c As Caption = New Caption(index,
                                        Caption.StringToTimeSpan(startTime),
                                        Caption.StringToTimeSpan(endTime),
                                        text)

            captions.Add(c)

            UpdateListViewCaption(lvOriginal, c)
            UpdateListViewCaption(lvOffsetted, c)
        Next
    End Sub

    Private Sub LoadVideo(fileName As String)
        sbCtrl.Position = TimeSpan.Zero
        btnPlay.Enabled = False
        tbPosition.Enabled = False
        sbCtrl.MediaDuration = TimeSpan.Zero
        mMediaIsValid = False

        If fileName <> "" AndAlso IO.File.Exists(fileName) Then
            If vlcCtrl.IsPlaying Then vlcCtrl.Stop()

            media = New Vlc.DotNet.Core.Medias.PathMedia(fileName)
            vlcCtrl.Media = media
            vlcCtrl.Play()

            Do
                Application.DoEvents()
                If media.State = Interops.Signatures.LibVlc.Media.States.Error Then Exit Sub
            Loop Until media.State = Interops.Signatures.LibVlc.Media.States.Playing

            If media.State = Interops.Signatures.LibVlc.Media.States.Error Then Exit Sub

            vlcCtrl.Position = 0
            vlcCtrl.Pause()

            cmbLanguages.Items.Clear()
            For i = 1 To vlcCtrl.AudioProperties.TrackCount - 1
                cmbLanguages.Items.Add("Track " + i.ToString())
            Next
            If cmbLanguages.Items.Count > 0 Then
                cmbLanguages.Enabled = True
                cmbLanguages.SelectedIndex = 0
            Else
                cmbLanguages.Enabled = False
            End If

            btnPlay.Enabled = True
            tbPosition.Enabled = True

            sbCtrl.MediaDuration = vlcCtrl.Media.Duration
            mMediaIsValid = True
        End If
    End Sub

    Private Sub SelectCaption(caption As Caption)
        If caption IsNot Nothing Then
            UpdateListViewCaption(lvOffsetted, caption, True)
            EditCaption()
        End If
    End Sub

    Public Sub UpdateListViewCaption(lv As ListView, c As Caption, Optional selectIt As Boolean = False, Optional autoResizeColumns As Boolean = False)
        Dim isOffsetted As Boolean = (lv.Name = lvOffsetted.Name)

        If lv.Items.Count >= c.Index Then
            With lv.Items(c.Index - 1)
                If isOffsetted Then
                    .SubItems(0).Text = c.FromTimeOffsetted.ToString()
                    .SubItems(1).Text = c.ToTimeOffsetted.ToString()
                    .SubItems(2).Text = c.TextOffsetted
                Else
                    .SubItems(0).Text = c.FromTimeOriginal.ToString()
                    .SubItems(1).Text = c.ToTimeOriginal.ToString()
                    .SubItems(2).Text = c.TextOriginal
                End If
                If selectIt Then
                    .Selected = True
                    .EnsureVisible()
                End If
            End With
        Else
            Dim newItem As ListViewItem
            If isOffsetted Then
                newItem = lv.Items.Add(c.FromTimeOffsetted.ToString())
                With newItem.SubItems
                    .Add(c.ToTimeOffsetted.ToString())
                    .Add(c.TextOffsetted)
                End With
            Else
                newItem = lv.Items.Add(c.FromTimeOriginal.ToString())
                With newItem.SubItems
                    .Add(c.ToTimeOriginal.ToString())
                    .Add(c.TextOriginal)
                End With
            End If

            If selectIt Then
                newItem.Selected = True
                newItem.EnsureVisible()
            End If
        End If

        'If autoResizeColumns Then lv.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
    End Sub

    Private Sub UpdateCaptions(captions As List(Of Caption))
        For Each c In captions
            UpdateListViewCaption(lvOffsetted, c)
        Next

        SaveOffsettedSubtitles(False)
    End Sub

    Public Sub SaveOffsettedSubtitles(applyChanges As Boolean)
        Dim tmpFile As String = GetTempFile()
        Dim oldPosition As Integer = tbPosition.Value
        Dim captionIndex As Integer = 0
        If GetSelectedCaption() IsNot Nothing Then captionIndex = GetSelectedCaption().Index

        If applyChanges Then
            If IO.File.Exists(tmpFile) Then
                UnloadVLCMedia()
                IO.File.Delete(tmpFile)
            End If
            tmpFile = txtSubtitlesFile.Text
        End If

        Dim w As IO.StreamWriter = New IO.StreamWriter(tmpFile, False, System.Text.Encoding.UTF8)
        If Not applyChanges OrElse subsFormat = SubsFormats.SRT Then
            For Each c In captions
                w.WriteLine(c.Index)
                w.WriteLine(c.GetOffsettedSRTTime())
                w.WriteLine(c.TextOffsetted)
                w.WriteLine()
            Next
        ElseIf subsFormat = SubsFormats.SUB Then
            For Each c In captions
                w.WriteLine(String.Format("{0}{1}", c.GetOffsettedSUBTime(videoFPS), c.TextOffsetted.Replace(vbCrLf, "|")))
            Next
        End If
        w.Close()

        If applyChanges Then LoadSubtitles(txtSubtitlesFile.Text)
        sbCtrl.SetCaptions(captions, False)

        If mMediaIsValid Then
            ' Workaround to solve the problem when VLC does not support any additional subtitle files.
            ' The only way (so far) to empty the list of added subtitle files is to re-load the video.
            If applyChanges OrElse vlcCtrl.VideoProperties.SpuCount > 70 Then
                LoadVideo(txtVideoFile.Text)

                tbPosition.Value = oldPosition
                If captionIndex > 0 Then
                    With lvOffsetted.Items(captionIndex - 1)
                        .Selected = True
                        .EnsureVisible()
                    End With
                    SelectCaption(GetSelectedCaption())
                End If
            End If

            vlcCtrl.VideoProperties.SetSubtitleFile(tmpFile)
        End If

        EditCaption()
    End Sub

    Private Sub UnloadVLCMedia()
        If mMediaIsValid Then vlcCtrl.Stop()
        Dim media = New Medias.EmptyMedia("")
        vlcCtrl.Media = media
    End Sub

    Private Function GetTempFile() As String
        Try
            Dim file As IO.FileInfo = New IO.FileInfo(txtSubtitlesFile.Text)
            Dim path As String = file.DirectoryName
            Dim newName As String = file.Name.Replace(file.Extension, "") + ".Offsetted" + file.Extension
            Return IO.Path.Combine(path, newName)
        Catch
            Return ""
        End Try
    End Function

    Private Sub UpdatePositionUI(percentage As Double)
        isUpdatingUI = True

        tbPosition.Value = percentage * 1000000
        Dim time As TimeSpan = TimeSpan.FromMilliseconds(VideoPosition)
        lblTime.Text = String.Format("{0:00}:{1:00}:{2:00},{3:000}",
                                    time.Hours,
                                    time.Minutes,
                                    time.Seconds,
                                    time.Milliseconds)

        sbCtrl.Position = time
        sbCtrl.CenterPosition(mMediaIsValid AndAlso vlcCtrl.IsPlaying)

        isUpdatingUI = False
    End Sub

    Private Property VideoPosition As Double
        Get
            Return vlcCtrl.Position * media.Duration.TotalMilliseconds
        End Get
        Set(value As Double)
            vlcCtrl.Position = value / media.Duration.TotalMilliseconds
        End Set
    End Property

    Public Sub EditCaption(Optional forceOpen As Boolean = False)
        Dim c As Caption = GetSelectedCaption()

        If forceOpen AndAlso captionEditor Is Nothing Then
            captionEditor = New frmEditCaption()
            AddHandler captionEditor.FormClosing, Sub() captionEditor = Nothing

            captionEditor.Show(Me)
        End If

        If captionEditor IsNot Nothing Then captionEditor.LoadCaption(c)
        sbCtrl.SelectedCaption = c
    End Sub

    Private Function GetSelectedCaption() As Caption
        If lvOffsetted.SelectedItems.Count = 1 Then
            Return captions(lvOffsetted.SelectedIndices(0))
        Else
            Return Nothing
        End If
    End Function

    Public Function AddCaption(Optional addLast As Boolean = False) As Caption
        Dim newCaption As Caption = Nothing
        Dim selectedCaption As Caption = GetSelectedCaption()

        If selectedCaption Is Nothing Then
            Dim lastCaption As Caption = Nothing
            Dim firstCaption As Caption = Nothing
            If captions.Count > 0 Then
                firstCaption = captions.First
                lastCaption = captions.Last()

                If addLast Then
                    newCaption = New Caption(lastCaption.Index + 1,
                                            lastCaption.ToTimeOffsetted + TimeSpan.FromSeconds(1),
                                            lastCaption.ToTimeOffsetted + TimeSpan.FromSeconds(3),
                                            "<new caption>")
                Else
                    newCaption = New Caption(firstCaption.Index,
                                             TimeSpan.FromSeconds(0),
                                             TimeSpan.FromSeconds(3),
                                            "<new caption>")
                End If
            Else
                newCaption = New Caption(1,
                                            TimeSpan.FromSeconds(0),
                                            TimeSpan.FromSeconds(2),
                                            "<new caption>")
            End If
        Else
            newCaption = New Caption(selectedCaption.Index + 1,
                                            selectedCaption.ToTimeOffsetted + TimeSpan.FromSeconds(1),
                                            selectedCaption.ToTimeOffsetted + TimeSpan.FromSeconds(3),
                                            "<new caption>")
        End If

        For i As Integer = newCaption.Index - 1 To captions.Count - 1
            captions(i).Index += 1
        Next
        captions.Insert(newCaption.Index - 1, newCaption)
        With lvOffsetted.Items.Insert(newCaption.Index - 1, "").SubItems
            .Add("")
            .Add("")
        End With
        UpdateListViewCaption(lvOffsetted, newCaption, True, True)
        EditCaption(True)

        Return newCaption
    End Function

    Private Sub SetUIState(state As Boolean)
        btnAddCaption.Enabled = state
        btnDeleteCaption.Enabled = state
        btnEditCaption.Enabled = state
        btnZoomIn.Enabled = state
        btnZoomOut.Enabled = state
        chkRippleEdits.Enabled = state
        sbCtrl.Enabled = state
        txtSearchOffsetted.Enabled = state
        txtSearchOriginal.Enabled = state
        btnSearchOffsettedDown.Enabled = state
        btnSearchOriginalDown.Enabled = state
    End Sub
End Class
