﻿Imports System.Threading

Public Class frmEditCaption
    Private Enum Modes
        SetEnd
        SetLength
    End Enum

    Private selectedCaption As Caption
    Private delayedDisableUI As Timer = New Timer(New TimerCallback(Sub() Me.Invoke(New MethodInvoker(Sub() Me.Enabled = False))), Nothing, Timeout.Infinite, Timeout.Infinite)
    Private ignoreChangeEvents As Boolean
    Private mode As Modes = Modes.SetEnd

    Public Sub LoadCaption(c As Caption)
        selectedCaption = c

        If selectedCaption Is Nothing Then
            delayedDisableUI.Change(500, Timeout.Infinite)
        Else
            delayedDisableUI.Change(Timeout.Infinite, Timeout.Infinite)
            Me.Enabled = True

            UpdateUI()
        End If
    End Sub

    Private Sub UpdateUI()
        If selectedCaption Is Nothing Then Exit Sub

        ignoreChangeEvents = True

        With selectedCaption
            nudHourStart.Text = .FromTimeOffsetted.Hours
            nudMinuteStart.Text = .FromTimeOffsetted.Minutes
            nudSecondStart.Text = .FromTimeOffsetted.Seconds
            nudMilliSecondStart.Text = .FromTimeOffsetted.Milliseconds

            Select Case mode
                Case Modes.SetEnd
                    nudHourEnd.Text = .ToTimeOffsetted.Hours
                    nudMinuteEnd.Text = .ToTimeOffsetted.Minutes
                    nudSecondEnd.Text = .ToTimeOffsetted.Seconds
                    nudMilliSecondEnd.Text = .ToTimeOffsetted.Milliseconds
                Case Modes.SetLength
                    Dim length = .ToTimeOffsetted - .FromTimeOffsetted
                    nudHourEnd.Text = length.Hours
                    nudMinuteEnd.Text = length.Minutes
                    nudSecondEnd.Text = length.Seconds
                    nudMilliSecondEnd.Text = length.Milliseconds
            End Select

            txtText.Text = .TextOffsetted
        End With

        ignoreChangeEvents = False
    End Sub

    Private Sub Time_ValueChanged(sender As System.Object, e As System.EventArgs) Handles nudHourStart.ValueChanged, nudHourEnd.ValueChanged,
                                                                                          nudMinuteStart.ValueChanged, nudMinuteEnd.ValueChanged,
                                                                                          nudSecondStart.ValueChanged, nudSecondEnd.ValueChanged,
                                                                                          nudMilliSecondStart.ValueChanged, nudMilliSecondEnd.ValueChanged

        If ignoreChangeEvents Then Exit Sub

        If nudMilliSecondEnd.Value = 1000 Then
            ignoreChangeEvents = True
            nudMilliSecondEnd.Value = 0
            ignoreChangeEvents = False

            nudSecondEnd.Value += 1
            Exit Sub
        ElseIf nudMilliSecondEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudMilliSecondEnd.Value = 999
            ignoreChangeEvents = False

            nudSecondEnd.Value -= 1
            Exit Sub
        End If

        If nudSecondEnd.Value = 60 Then
            ignoreChangeEvents = True
            nudSecondEnd.Value = 0
            ignoreChangeEvents = False

            nudMinuteEnd.Value += 1
            Exit Sub
        ElseIf nudSecondEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudSecondEnd.Value = 59
            ignoreChangeEvents = False

            nudMinuteEnd.Value -= 1
            Exit Sub
        End If

        If nudMinuteEnd.Value = 60 Then
            ignoreChangeEvents = True
            nudMinuteEnd.Value = 0
            ignoreChangeEvents = False

            If nudHourEnd.Value < 99 Then nudHourEnd.Value += 1
            Exit Sub
        ElseIf nudMinuteEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudMinuteEnd.Value = 59
            ignoreChangeEvents = False

            If nudHourEnd.Value > 0 Then nudHourEnd.Value -= 1
            Exit Sub
        End If

        ' -----------------------

        If nudMilliSecondStart.Value = 1000 Then
            ignoreChangeEvents = True
            nudMilliSecondStart.Value = 0
            ignoreChangeEvents = False

            nudSecondStart.Value += 1
            Exit Sub
        ElseIf nudMilliSecondStart.Value = -1 Then
            ignoreChangeEvents = True
            nudMilliSecondStart.Value = 999
            ignoreChangeEvents = False

            nudSecondStart.Value -= 1
            Exit Sub
        End If

        If nudSecondStart.Value = 60 Then
            ignoreChangeEvents = True
            nudSecondStart.Value = 0
            ignoreChangeEvents = False

            nudMinuteStart.Value += 1
            Exit Sub
        ElseIf nudSecondStart.Value = -1 Then
            ignoreChangeEvents = True
            nudSecondStart.Value = 59
            ignoreChangeEvents = False

            nudMinuteStart.Value -= 1
            Exit Sub
        End If

        If nudMinuteStart.Value = 60 Then
            ignoreChangeEvents = True
            nudMinuteStart.Value = 0
            ignoreChangeEvents = False

            If nudHourStart.Value < 99 Then nudHourStart.Value += 1
            Exit Sub
        ElseIf nudMinuteStart.Value = -1 Then
            ignoreChangeEvents = True
            nudMinuteStart.Value = 59
            ignoreChangeEvents = False

            If nudHourStart.Value > 0 Then nudHourStart.Value -= 1
            Exit Sub
        End If

        UpdateCaption()
    End Sub

    Private Sub txtText_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtText.TextChanged
        UpdateCaption()
    End Sub

    Private Sub UpdateCaption()
        If ignoreChangeEvents Then Exit Sub

        If selectedCaption IsNot Nothing Then
            selectedCaption.FromTimeOffsetted = StartToTimeSpan()

            Select Case mode
                Case Modes.SetEnd
                    selectedCaption.ToTimeOffsetted = EndToTimeSpan()
                Case Modes.SetLength
                    selectedCaption.ToTimeOffsetted = StartToTimeSpan() + EndToTimeSpan()
            End Select
            selectedCaption.TextOffsetted = txtText.Text

            With CType(Me.Owner, frmMain)
                .UpdateListViewCaption(frmMain.lvOffsetted, selectedCaption, , True)
                .SaveOffsettedSubtitles(False)
            End With
        End If
    End Sub

    Private Sub rbEnd_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles rbEnd.CheckedChanged
        mode = Modes.SetEnd
        UpdateUI()
    End Sub

    Private Sub rbLength_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles rbLength.CheckedChanged
        mode = Modes.SetLength
        UpdateUI()
    End Sub

    Private Function StartToTimeSpan() As TimeSpan
        Return New TimeSpan(0, nudHourStart.Value, nudMinuteStart.Value, nudSecondStart.Value, nudMilliSecondStart.Value)
    End Function

    Private Function EndToTimeSpan() As TimeSpan
        Return New TimeSpan(0, nudHourEnd.Value, nudMinuteEnd.Value, nudSecondEnd.Value, nudMilliSecondEnd.Value)
    End Function

    Private Sub btnBold_Click(sender As System.Object, e As System.EventArgs) Handles btnBold.Click
        ToggleTag("<b>", "</b>")
    End Sub

    Private Sub btnItalic_Click(sender As System.Object, e As System.EventArgs) Handles btnItalic.Click
        ToggleTag("<i>", "</i>")
    End Sub

    Private Sub txtText_Click(sender As Object, e As System.EventArgs) Handles txtText.Click
        Try
            Dim p = GetInnerText("<font color", "</font>")
            Dim innerText As String = txtText.Text.Substring(p(0), p(1) - p(0))

            If innerText.StartsWith("<font color") AndAlso innerText.EndsWith("</font>") Then
                Dim hexColor As String = innerText.Split("#")(1).Split("""")(0)

                Dim r As Integer = Integer.Parse(hexColor.Substring(0, 2), Globalization.NumberStyles.HexNumber)
                Dim g As Integer = Integer.Parse(hexColor.Substring(2, 2), Globalization.NumberStyles.HexNumber)
                Dim b As Integer = Integer.Parse(hexColor.Substring(4, 2), Globalization.NumberStyles.HexNumber)

                btnColor.BackColor = Color.FromArgb(r, g, b)
            Else
                btnColor.BackColor = Color.White
            End If
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical Or MsgBoxStyle.OkOnly)
        End Try
    End Sub

    Private Sub ToggleTag(openingTag As String, closingTag As String)
        Try
            Dim p = GetInnerText(openingTag, closingTag)
            Dim innerText As String = txtText.Text.Substring(p(0), p(1) - p(0))

            If innerText.StartsWith(openingTag) AndAlso innerText.EndsWith(closingTag) Then
                txtText.Text = txtText.Text.Substring(0, p(0)) +
                                innerText.Substring(openingTag.Length, innerText.Length - (openingTag.Length + closingTag.Length)) +
                                txtText.Text.Substring(p(1))
            Else
                txtText.Text = txtText.Text.Substring(0, p(0)) + openingTag + innerText + closingTag + txtText.Text.Substring(p(1))
            End If
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical Or MsgBoxStyle.OkOnly)
        End Try
    End Sub

    Private Function GetInnerText(openingTag As String, closingTag As String) As Integer()
        If txtText.SelectedText <> "" Then Return {txtText.SelectionStart, txtText.SelectionStart + txtText.SelectionLength}

        If openingTag.Contains(" ") Then openingTag = openingTag.Split(" ")(0)

        If txtText.SelectionStart = 0 OrElse txtText.SelectionStart = txtText.TextLength - 1 Then
            Return {0, txtText.TextLength}
        Else
            Dim startIndex As Integer
            Dim endIndex As Integer
            Dim testIndex As Integer

            For startIndex = txtText.SelectionStart To 0 Step -1
                If startIndex = txtText.TextLength Then Continue For

                If txtText.Text(startIndex) = ">" Then
                    Do
                        testIndex = FindChar("<", startIndex, -1)
                        If testIndex = startIndex Then
                            Exit Do
                        Else
                            startIndex = testIndex
                        End If
                        If txtText.Text.Substring(startIndex, openingTag.Length) = openingTag Then
                            startIndex -= 1
                            Exit For
                        End If
                    Loop
                End If
            Next
            startIndex += 1

            For endIndex = txtText.SelectionStart To txtText.TextLength - 1
                If txtText.Text(endIndex) = "<" Then
                    Do
                        testIndex = FindChar(">", endIndex, 1)
                        If testIndex = endIndex Then
                            Exit Do
                        Else
                            endIndex = testIndex
                        End If
                        If txtText.Text.Substring(endIndex - closingTag.Length + 1, closingTag.Length) = closingTag Then
                            endIndex += 1
                            Exit For
                        End If
                    Loop
                End If
            Next

            Return {startIndex, endIndex}
        End If
    End Function

    Private Function FindChar(c As Char, position As Integer, direction As Integer) As Integer
        Do Until txtText.Text(position) = c OrElse position = 0 OrElse position = txtText.TextLength - 1
            position += direction
        Loop

        Return position
    End Function

    Private Sub btnColor_Click(sender As System.Object, e As System.EventArgs) Handles btnColor.Click
        Using dlg = New ColorDialog()
            dlg.Color = btnColor.BackColor
            If dlg.ShowDialog = Windows.Forms.DialogResult.OK Then
                btnColor.BackColor = dlg.Color

                ToggleTag(String.Format("<font color=""#{0}{1}{2}"">",
                                        dlg.Color.R.ToString("X").PadLeft(2, "0"),
                                        dlg.Color.G.ToString("X").PadLeft(2, "0"),
                                        dlg.Color.B.ToString("X").PadLeft(2, "0")),
                                    "</font>")
            End If
        End Using
    End Sub
End Class