﻿Imports System.Threading

Public Class frmEditCaption
    Private Enum Modes
        SetEnd
        SetLength
    End Enum

    Private selectedCaption As Caption
    Private delayedDisableUI As Timer = New Timer(New TimerCallback(Sub() Me.Invoke(New MethodInvoker(Sub() Me.Enabled = False))), Nothing, Timeout.Infinite, Timeout.Infinite)
    Private ignoreChangeEvents As Boolean
    Private mode As Modes = Modes.SetEnd

    Public Sub LoadCaption(c As Caption)
        selectedCaption = c

        If selectedCaption Is Nothing Then
            delayedDisableUI.Change(500, Timeout.Infinite)
        Else
            delayedDisableUI.Change(Timeout.Infinite, Timeout.Infinite)
            Me.Enabled = True

            UpdateUI()
        End If
    End Sub

    Private Sub UpdateUI()
        If selectedCaption Is Nothing Then Exit Sub

        ignoreChangeEvents = True

        With selectedCaption
            nudHourStart.Text = .FromTimeOffsetted.Hours
            nudMinuteStart.Text = .FromTimeOffsetted.Minutes
            nudSecondStart.Text = .FromTimeOffsetted.Seconds
            nudMilliSecondStart.Text = .FromTimeOffsetted.Milliseconds

            Select Case mode
                Case Modes.SetEnd
                    nudHourEnd.Text = .ToTimeOffsetted.Hours
                    nudMinuteEnd.Text = .ToTimeOffsetted.Minutes
                    nudSecondEnd.Text = .ToTimeOffsetted.Seconds
                    nudMilliSecondEnd.Text = .ToTimeOffsetted.Milliseconds
                Case Modes.SetLength
                    Dim length = .ToTimeOffsetted - .FromTimeOffsetted
                    nudHourEnd.Text = length.Hours
                    nudMinuteEnd.Text = length.Minutes
                    nudSecondEnd.Text = length.Seconds
                    nudMilliSecondEnd.Text = length.Milliseconds
            End Select

            txtText.Text = .TextOffsetted
        End With

        ignoreChangeEvents = False
    End Sub

    Private Sub Time_ValueChanged(sender As System.Object, e As System.EventArgs) Handles nudHourStart.ValueChanged, nudHourEnd.ValueChanged,
                                                                                          nudMinuteStart.ValueChanged, nudMinuteEnd.ValueChanged,
                                                                                          nudSecondStart.ValueChanged, nudSecondEnd.ValueChanged,
                                                                                          nudMilliSecondStart.ValueChanged, nudMilliSecondEnd.ValueChanged

        If ignoreChangeEvents Then Exit Sub

        If nudMilliSecondEnd.Value = 1000 Then
            ignoreChangeEvents = True
            nudMilliSecondEnd.Value = 0
            ignoreChangeEvents = False

            nudSecondEnd.Value += 1
            Exit Sub
        ElseIf nudMilliSecondEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudMilliSecondEnd.Value = 999
            ignoreChangeEvents = False

            nudSecondEnd.Value -= 1
            Exit Sub
        End If

        If nudSecondEnd.Value = 60 Then
            ignoreChangeEvents = True
            nudSecondEnd.Value = 0
            ignoreChangeEvents = False

            nudMinuteEnd.Value += 1
            Exit Sub
        ElseIf nudSecondEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudSecondEnd.Value = 59
            ignoreChangeEvents = False

            nudMinuteEnd.Value -= 1
            Exit Sub
        End If

        If nudMinuteEnd.Value = 60 Then
            ignoreChangeEvents = True
            nudMinuteEnd.Value = 0
            ignoreChangeEvents = False

            If nudHourEnd.Value < 99 Then nudHourEnd.Value += 1
            Exit Sub
        ElseIf nudMinuteEnd.Value = -1 Then
            ignoreChangeEvents = True
            nudMinuteEnd.Value = 59
            ignoreChangeEvents = False

            If nudHourEnd.Value > 0 Then nudHourEnd.Value -= 1
            Exit Sub
        End If

        ' -----------------------

        If nudMilliSecondStart.Value = 1000 Then
            ignoreChangeEvents = True
            nudMilliSecondStart.Value = 0
            ignoreChangeEvents = False

            nudSecondStart.Value += 1
            Exit Sub
        ElseIf nudMilliSecondStart.Value = -1 Then
            ignoreChangeEvents = True
            nudMilliSecondStart.Value = 999
            ignoreChangeEvents = False

            nudSecondStart.Value -= 1
            Exit Sub
        End If

        If nudSecondStart.Value = 60 Then
            ignoreChangeEvents = True
            nudSecondStart.Value = 0
            ignoreChangeEvents = False

            nudMinuteStart.Value += 1
            Exit Sub
        ElseIf nudSecondStart.Value = -1 Then
            ignoreChangeEvents = True
            nudSecondStart.Value = 59
            ignoreChangeEvents = False

            nudMinuteStart.Value -= 1
            Exit Sub
        End If

        If nudMinuteStart.Value = 60 Then
            ignoreChangeEvents = True
            nudMinuteStart.Value = 0
            ignoreChangeEvents = False

            If nudHourStart.Value < 99 Then nudHourStart.Value += 1
            Exit Sub
        ElseIf nudMinuteStart.Value = -1 Then
            ignoreChangeEvents = True
            nudMinuteStart.Value = 59
            ignoreChangeEvents = False

            If nudHourStart.Value > 0 Then nudHourStart.Value -= 1
            Exit Sub
        End If

        UpdateCaption()
    End Sub

    Private Sub txtText_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtText.TextChanged
        UpdateCaption()
    End Sub

    Private Sub UpdateCaption()
        If ignoreChangeEvents Then Exit Sub

        If selectedCaption IsNot Nothing Then
            selectedCaption.FromTimeOffsetted = StartToTimeSpan()

            Select Case mode
                Case Modes.SetEnd
                    selectedCaption.ToTimeOffsetted = EndToTimeSpan()
                Case Modes.SetLength
                    selectedCaption.ToTimeOffsetted = StartToTimeSpan() + EndToTimeSpan()
            End Select
            selectedCaption.TextOffsetted = txtText.Text

            With CType(Me.Owner, frmMain)
                .UpdateListViewCaption(frmMain.lvOffsetted, selectedCaption, , True)
                .SaveOffsettedSubtitles(False)
            End With
        End If
    End Sub

    Private Sub rbEnd_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles rbEnd.CheckedChanged
        mode = Modes.SetEnd
        UpdateUI()
    End Sub

    Private Sub rbLength_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles rbLength.CheckedChanged
        mode = Modes.SetLength
        UpdateUI()
    End Sub

    Private Function StartToTimeSpan() As TimeSpan
        Return New TimeSpan(0, nudHourStart.Value, nudMinuteStart.Value, nudSecondStart.Value, nudMilliSecondStart.Value)
    End Function

    Private Function EndToTimeSpan() As TimeSpan
        Return New TimeSpan(0, nudHourEnd.Value, nudMinuteEnd.Value, nudSecondEnd.Value, nudMilliSecondEnd.Value)
    End Function
End Class