﻿Imports Vlc.DotNet.Core

Public Class frmMain
    Private captions As List(Of Caption) = New List(Of Caption)
    Private mMediaIsValid As Boolean = False
    Private media As Vlc.DotNet.Core.Medias.PathMedia
    Private captionEditor As frmEditCaption
    Private isUpdatingUI As Boolean
    Private ignoreListViewSelectionEvent As Boolean

#Region "Controls Events"
    Private Sub frmMain_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim tmpFile As String = GetTempFile()

        If vlcCtrl.IsPlaying Then vlcCtrl.Stop()

        If IO.File.Exists(tmpFile) Then
            Select Case MsgBox("You have unsaved changes." + vbCrLf + "Would you like to apply them now?",
                               MsgBoxStyle.Question Or MsgBoxStyle.YesNoCancel)
                Case MsgBoxResult.No
                    IO.File.Delete(tmpFile)
                Case MsgBoxResult.Yes
                    SaveOffsettedSubtitles(True)
                Case MsgBoxResult.Cancel
                    e.Cancel = True
            End Select
        End If
    End Sub

    Private Sub btnBrowseSubtitlesFile_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowseSubtitlesFile.Click
        Using dlg = New OpenFileDialog()
            dlg.Filter = "Subtitles File (*.srt)|*.srt"
            dlg.Title = "Select Subtitles File"
            If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
                txtSubtitlesFile.Text = dlg.FileName
                LoadSubtitles()
            End If
        End Using
    End Sub

    Private Sub btnClose_Click(sender As System.Object, e As System.EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub btnSave_Click(sender As System.Object, e As System.EventArgs) Handles btnSave.Click
        Me.Enabled = False
        SaveOffsettedSubtitles(True)
        Me.Enabled = True
    End Sub

    Private Sub btnBrowseVideoFile_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowseVideoFile.Click
        Using dlg = New OpenFileDialog()
            dlg.Filter = "Video Files|*.avi;*.mpg;*.mp4;*.mkv|All Files|*.*"
            dlg.Title = "Select Video File"
            If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
                txtVideoFile.Text = dlg.FileName
                LoadVideo(dlg.FileName)
            End If
        End Using
    End Sub

    Private Sub lvOffsetted_DoubleClick(sender As Object, e As System.EventArgs) Handles lvOffsetted.DoubleClick
        EditCaption(True)
    End Sub

    Private Sub lvOffsetted_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles lvOffsetted.SelectedIndexChanged
        If ignoreListViewSelectionEvent Then Exit Sub

        Dim c As Caption = GetSelectedCaption()

        If c IsNot Nothing Then
            If mMediaIsValid Then
                VideoPosition = c.FromTimeOffsetted.TotalMilliseconds
                UpdatePositionUI(vlcCtrl.Position)
                If vlcCtrl.IsPlaying Then sbCtrl.CenterPosition(False)
            Else
                sbCtrl.Position = c.FromTimeOffsetted
                sbCtrl.CenterPosition(False)
            End If
        End If

        EditCaption()
    End Sub

    Private Sub vlcCtrl_PositionChanged(sender As Vlc.DotNet.Forms.VlcControl, e As Vlc.DotNet.Core.VlcEventArgs(Of Single)) Handles vlcCtrl.PositionChanged
        UpdatePositionUI(e.Data)

        Dim captionAtPosition = sbCtrl.GetCaptionAtPosition()
        If captionAtPosition IsNot Nothing Then
            ignoreListViewSelectionEvent = True
            SelectCaption(captionAtPosition)
            ignoreListViewSelectionEvent = False
        End If
    End Sub

    Private Sub tbPosition_ValueChanged(sender As Object, e As System.EventArgs) Handles tbPosition.ValueChanged
        If isUpdatingUI Then Exit Sub
        vlcCtrl.Position = tbPosition.Value / 1000000
        UpdatePositionUI(vlcCtrl.Position)
    End Sub

    Private Sub btnPlay_Click(sender As System.Object, e As System.EventArgs) Handles btnPlay.Click
        If vlcCtrl.IsPlaying Then
            vlcCtrl.Pause()
        Else
            vlcCtrl.Play()
        End If
    End Sub

    Private Sub cmbLanguages_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbLanguages.SelectedIndexChanged
        vlcCtrl.AudioProperties.Track = CInt(cmbLanguages.SelectedIndex + 1)
    End Sub

    Private Sub btnDeleteCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnDeleteCaption.Click
        If lvOffsetted.SelectedItems.Count = 0 Then Exit Sub

        Dim c = captions(lvOffsetted.SelectedIndices(0))
        captions.Remove(c)
        lvOffsetted.Items.Remove(lvOffsetted.SelectedItems(0))

        For i As Integer = c.Index - 1 To captions.Count - 1
            captions(i).Index -= 1
        Next
        SaveOffsettedSubtitles(False)
    End Sub

    Private Sub btnEditCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnEditCaption.Click
        If lvOffsetted.SelectedItems.Count = 0 Then Exit Sub

        EditCaption(True)
    End Sub

    Private Sub sbCtrl_CaptionsChanged(captions As System.Collections.Generic.List(Of Caption)) Handles sbCtrl.CaptionsChanged
        UpdateCaptions(captions)
    End Sub

    Private Sub sbCtrl_CaptionSelected(caption As Caption, changed As Boolean) Handles sbCtrl.CaptionSelected
        SelectCaption(caption)
        If changed Then SaveOffsettedSubtitles(False)
    End Sub

    Private Sub sbCtrl_PositionChanged(position As System.TimeSpan, caption As Caption) Handles sbCtrl.PositionChanged
        If mMediaIsValid AndAlso caption Is Nothing Then
            tbPosition.Value = position.TotalMilliseconds / media.Duration.TotalMilliseconds * 1000000
        End If
    End Sub

    Private Sub btnAddCaption_Click(sender As System.Object, e As System.EventArgs) Handles btnAddCaption.Click
        AddCaption()
    End Sub

    Private Sub btnZoomIn_Click(sender As System.Object, e As System.EventArgs) Handles btnZoomIn.Click
        sbCtrl.ZoomFactor += 1
    End Sub

    Private Sub btnZoomOut_Click(sender As System.Object, e As System.EventArgs) Handles btnZoomOut.Click
        sbCtrl.ZoomFactor -= 1
    End Sub

    Private Sub chkRippleEdits_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkRippleEdits.CheckedChanged
        Select Case chkRippleEdits.Checked
            Case True
                chkRippleEdits.Image = My.Resources.lock
            Case False
                chkRippleEdits.Image = My.Resources.lock_open
        End Select
        sbCtrl.RippleEdits = chkRippleEdits.Checked
    End Sub
#End Region

    Private Sub LoadSubtitles()
        Dim lines() = IO.File.ReadAllLines(txtSubtitlesFile.Text, System.Text.Encoding.UTF7)

        captions.Clear()

        Dim index As Integer = 0

        lvOriginal.Items.Clear()
        lvOffsetted.Items.Clear()
        For i As Integer = 0 To lines.Count - 1
            Do While i < lines.Count AndAlso lines(i) = ""
                i += 1
            Loop
            If i = lines.Count Then Exit For

            index += 1
            Dim startTime As String = lines(i + 1).Split(" "c)(0)
            Dim endTime As String = lines(i + 1).Split(" "c)(2)

            Dim text As String = ""
            i += 2
            Do While i < lines.Count AndAlso lines(i) <> ""
                text += lines(i) + vbCrLf
                i += 1
            Loop
            If text <> "" Then text = text.Substring(0, text.Length - 2)

            captions.Add(New Caption(index,
                                        Caption.StringToTimeSpan(startTime),
                                        Caption.StringToTimeSpan(endTime),
                                        text))
            UpdateListViewCaption(lvOriginal, captions.Last())
            UpdateListViewCaption(lvOffsetted, captions.Last())
        Next

        lvOriginal.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
        lvOffsetted.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)

        btnAddCaption.Enabled = True
        btnDeleteCaption.Enabled = True
        btnEditCaption.Enabled = True
        btnZoomIn.Enabled = True
        btnZoomOut.Enabled = True
        chkRippleEdits.Enabled = True
        sbCtrl.Enabled = True

        vlcCtrl.VideoProperties.SetSubtitleFile(txtSubtitlesFile.Text)
        EditCaption()

        sbCtrl.SetCaptions(captions, True)
    End Sub

    Private Sub LoadVideo(fileName As String)
        sbCtrl.Position = TimeSpan.Zero

        If fileName <> "" AndAlso IO.File.Exists(fileName) Then
            If vlcCtrl.IsPlaying Then vlcCtrl.Stop()

            media = New Vlc.DotNet.Core.Medias.PathMedia(fileName)
            vlcCtrl.SetMedia(media)
            vlcCtrl.Play()
            vlcCtrl.Position = 0
            Threading.Thread.Sleep(500)
            vlcCtrl.Pause()

            cmbLanguages.Items.Clear()
            For i = 1 To vlcCtrl.AudioProperties.TrackCount - 1
                cmbLanguages.Items.Add("Track " + i.ToString())
            Next
            If cmbLanguages.Items.Count > 0 Then
                cmbLanguages.Enabled = True
                cmbLanguages.SelectedIndex = 0
            Else
                cmbLanguages.Enabled = False
            End If

            btnPlay.Enabled = True
            tbPosition.Enabled = True

            mMediaIsValid = True
        Else
            btnPlay.Enabled = False
            tbPosition.Enabled = False

            mMediaIsValid = False
        End If
    End Sub

    Private Sub SelectCaption(caption As Caption)
        If caption IsNot Nothing Then
            UpdateListViewCaption(lvOffsetted, caption, True)
            EditCaption()
        End If
    End Sub

    Public Sub UpdateListViewCaption(lv As ListView, c As Caption, Optional selectIt As Boolean = False, Optional autoResizeColumns As Boolean = False)
        Dim isOffsetted As Boolean = (lv.Name = lvOffsetted.Name)

        If lv.Items.Count >= c.Index Then
            With lv.Items(c.Index - 1)
                If isOffsetted Then
                    .SubItems(0).Text = c.FromTimeOffsetted.ToString()
                    .SubItems(1).Text = c.ToTimeOffsetted.ToString()
                    .SubItems(2).Text = c.TextOffsetted
                Else
                    .SubItems(0).Text = c.FromTimeOriginal.ToString()
                    .SubItems(1).Text = c.ToTimeOriginal.ToString()
                    .SubItems(2).Text = c.TextOriginal
                End If
                If selectIt Then
                    .Selected = True
                    .EnsureVisible()
                End If
            End With
        Else
            Dim newItem As ListViewItem
            If isOffsetted Then
                newItem = lv.Items.Add(c.FromTimeOffsetted.ToString())
                With newItem.SubItems
                    .Add(c.ToTimeOffsetted.ToString())
                    .Add(c.TextOffsetted)
                End With
            Else
                newItem = lv.Items.Add(c.FromTimeOriginal.ToString())
                With newItem.SubItems
                    .Add(c.ToTimeOriginal.ToString())
                    .Add(c.TextOriginal)
                End With
            End If

            If selectIt Then
                newItem.Selected = True
                newItem.EnsureVisible()
            End If
        End If

        'If autoResizeColumns Then lv.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
    End Sub

    Private Sub UpdateCaptions(captions As List(Of Caption))
        For Each c In captions
            UpdateListViewCaption(lvOffsetted, c)
        Next

        SaveOffsettedSubtitles(False)
    End Sub

    Public Sub SaveOffsettedSubtitles(overWrite As Boolean)
        Dim tmpFile As String = GetTempFile()
        Dim oldPosition As Integer = tbPosition.Value
        Dim captionIndex As Integer = 0
        If GetSelectedCaption() IsNot Nothing Then captionIndex = GetSelectedCaption().Index

        If overWrite Then
            If IO.File.Exists(tmpFile) Then
                If mMediaIsValid Then vlcCtrl.Stop()
                IO.File.Delete(tmpFile)
            End If
            tmpFile = txtSubtitlesFile.Text
        End If

        Dim w As IO.StreamWriter = New IO.StreamWriter(tmpFile)
        For Each c In captions
            w.WriteLine(c.Index)
            w.WriteLine(c.GetOffsettedTime())
            w.WriteLine(c.TextOffsetted)
            w.WriteLine()
        Next
        w.Close()

        If overWrite Then LoadSubtitles()
        sbCtrl.SetCaptions(captions, False)

        If mMediaIsValid Then
            ' Workaround to solve the problem when VLC does not support any additional subtitle files.
            ' The only way (so far) to empty the list of added subtitle files is to re-load the video.
            If overWrite OrElse vlcCtrl.VideoProperties.SpuCount > 70 Then
                LoadVideo(txtVideoFile.Text)
                For i As Integer = 0 To 100
                    Application.DoEvents()
                Next

                tbPosition.Value = oldPosition
                If captionIndex > 0 Then
                    With lvOffsetted.Items(captionIndex - 1)
                        .Selected = True
                        .EnsureVisible()
                    End With
                    SelectCaption(GetSelectedCaption())
                End If
            End If

            vlcCtrl.VideoProperties.SetSubtitleFile(tmpFile)
        End If

        EditCaption()
    End Sub

    Private Function GetTempFile() As String
        Try
            Dim file As IO.FileInfo = New IO.FileInfo(txtSubtitlesFile.Text)
            Dim path As String = file.DirectoryName
            Dim newName As String = file.Name.Replace(file.Extension, "") + ".Offsetted" + file.Extension
            Return IO.Path.Combine(path, newName)
        Catch
            Return ""
        End Try
    End Function

    Private Sub UpdatePositionUI(percentage As Double)
        isUpdatingUI = True

        tbPosition.Value = percentage * 1000000
        Dim time As TimeSpan = TimeSpan.FromMilliseconds(VideoPosition)
        lblTime.Text = String.Format("{0:00}:{1:00}:{2:00},{3:000}",
                                    time.Hours,
                                    time.Minutes,
                                    time.Seconds,
                                    time.Milliseconds)

        sbCtrl.Position = time
        sbCtrl.CenterPosition(mMediaIsValid AndAlso vlcCtrl.IsPlaying)

        isUpdatingUI = False
    End Sub

    Private Property VideoPosition As Double
        Get
            Return vlcCtrl.Position * media.Duration.TotalMilliseconds
        End Get
        Set(value As Double)
            vlcCtrl.Position = value / media.Duration.TotalMilliseconds
        End Set
    End Property

    Public Sub EditCaption(Optional forceOpen As Boolean = False)
        Dim c As Caption = GetSelectedCaption()

        If forceOpen AndAlso captionEditor Is Nothing Then
            captionEditor = New frmEditCaption()
            AddHandler captionEditor.FormClosing, Sub() captionEditor = Nothing

            captionEditor.Show(Me)
        End If

        If captionEditor IsNot Nothing Then captionEditor.LoadCaption(c)
        sbCtrl.SelectedCaption = c
    End Sub

    Private Function GetSelectedCaption() As Caption
        If lvOffsetted.SelectedItems.Count = 1 Then
            Return captions(lvOffsetted.SelectedIndices(0))
        Else
            Return Nothing
        End If
    End Function

    Public Function AddCaption(Optional addLast As Boolean = False) As Caption
        Dim newCaption As Caption = Nothing
        Dim selectedCaption As Caption = GetSelectedCaption()

        If selectedCaption Is Nothing Then
            Dim lastCaption As Caption = Nothing
            Dim firstCaption As Caption = Nothing
            If captions.Count > 0 Then
                firstCaption = captions.First
                lastCaption = captions.Last()

                If addLast Then
                    newCaption = New Caption(lastCaption.Index + 1,
                                            lastCaption.ToTimeOffsetted + TimeSpan.FromSeconds(1),
                                            lastCaption.ToTimeOffsetted + TimeSpan.FromSeconds(3),
                                            "<new caption>")
                Else
                    newCaption = New Caption(firstCaption.Index,
                                             TimeSpan.FromSeconds(0),
                                             TimeSpan.FromSeconds(3),
                                            "<new caption>")
                End If
            Else
                newCaption = New Caption(1,
                                            TimeSpan.FromSeconds(0),
                                            TimeSpan.FromSeconds(2),
                                            "<new caption>")
            End If
        Else
            newCaption = New Caption(selectedCaption.Index + 1,
                                            selectedCaption.ToTimeOffsetted + TimeSpan.FromSeconds(1),
                                            selectedCaption.ToTimeOffsetted + TimeSpan.FromSeconds(3),
                                            "<new caption>")
        End If

        For i As Integer = newCaption.Index - 1 To captions.Count - 1
            captions(i).Index += 1
        Next
        captions.Insert(newCaption.Index - 1, newCaption)
        With lvOffsetted.Items.Insert(newCaption.Index - 1, "").SubItems
            .Add("")
            .Add("")
        End With
        UpdateListViewCaption(lvOffsetted, newCaption, True, True)
        EditCaption(True)

        Return newCaption
    End Function
End Class
