﻿Public Class frmMain

    Private Class Caption
        Private mIndex As Integer
        Private mFromTime As TimeSpan
        Private mToTime As TimeSpan
        Private mText As String

        Public Sub New(index As Integer, fromTime As TimeSpan, toTime As TimeSpan, text As String)
            mIndex = index
            mFromTime = fromTime
            mToTime = toTime
            mText = text
        End Sub

        Public ReadOnly Property Index As Integer
            Get
                Return mIndex
            End Get
        End Property

        Public Property FromTime As TimeSpan
            Get
                Return mFromTime
            End Get
            Set(value As TimeSpan)
                mFromTime = value
            End Set
        End Property

        Public Property ToTime As TimeSpan
            Get
                Return mToTime
            End Get
            Set(value As TimeSpan)
                mToTime = value
            End Set
        End Property

        Public ReadOnly Property Text As String
            Get
                Return mText
            End Get
        End Property

        Public Function GetTime() As String
            Return String.Format("{0}:{1}:{2},{3} --> {4}:{5}:{6},{7}",
                                 mFromTime.Hours,
                                 mFromTime.Minutes,
                                 mFromTime.Seconds,
                                 mFromTime.Milliseconds,
                                 mToTime.Hours,
                                 mToTime.Minutes,
                                 mToTime.Seconds,
                                 mToTime.Milliseconds)
        End Function

        Public Shared Function StringToTimeSpan(textTime As String) As TimeSpan
            Dim tokens() = textTime.Replace(",", ":").Split(":"c)
            Dim h As Integer = tokens(0)
            Dim m As Integer = tokens(1)
            Dim s As Integer = tokens(2)
            Dim ms As Integer = tokens(3)

            Return New TimeSpan(0, h, m, s, ms)
        End Function
    End Class

    Private originalCaptions As List(Of Caption)
    Private offsettedCaptions As List(Of Caption)

    Private Sub btnOpen_Click(sender As System.Object, e As System.EventArgs) Handles btnOpen.Click
        Using dlg = New OpenFileDialog()
            dlg.Filter = "Subtitles (*.srt)|*.srt"
            dlg.Title = "Select Subtitles File"
            If dlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
                txtSubtitlesFile.Text = dlg.FileName
                LoadSubtitles()
            End If
        End Using
    End Sub

    Private Sub LoadSubtitles()
        Dim lines() = IO.File.ReadAllLines(txtSubtitlesFile.Text)

        originalCaptions = New List(Of Caption)
        offsettedCaptions = New List(Of Caption)

        lvOriginal.Items.Clear()
        lvOffsetted.Items.Clear()
        For i As Integer = 0 To lines.Count - 1

            Dim index As Integer = CInt(lines(i))
            Dim t1 As String = lines(i + 1).Split(" "c)(0)
            Dim t2 As String = lines(i + 1).Split(" "c)(2)

            Dim text As String = ""
            i += 2
            Do While i < lines.Count AndAlso lines(i) <> ""
                text += lines(i) + vbCrLf
                i += 1
            Loop
            If text <> "" Then text = text.Substring(0, text.Length - 2)

            originalCaptions.Add(New Caption(index,
                                        Caption.StringToTimeSpan(t1),
                                        Caption.StringToTimeSpan(t2),
                                        text))
            UpdateListViewCaption(lvOriginal, originalCaptions.Last())

            offsettedCaptions.Add(New Caption(index,
                                        Caption.StringToTimeSpan(t1),
                                        Caption.StringToTimeSpan(t2),
                                        text))
            UpdateListViewCaption(lvOffsetted, offsettedCaptions.Last())
        Next

        lvOriginal.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
        lvOffsetted.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent)
    End Sub

    Private Sub UpdateListViewCaption(lv As ListView, c As Caption)
        If lv.Items.Count >= c.Index Then
            lv.Items(c.Index - 1).SubItems(0).Text = c.FromTime.ToString()
            lv.Items(c.Index - 1).SubItems(1).Text = c.ToTime.ToString()
        Else
            With lv.Items.Add(c.FromTime.ToString()).SubItems
                .Add(c.ToTime.ToString())
                .Add(c.Text)
            End With
        End If
    End Sub

    Private Sub OffsetChanged(sender As System.Object, e As System.EventArgs) Handles nudMilliseconds.ValueChanged, nudSeconds.ValueChanged
        UpdateOffsetted()
    End Sub

    Private Sub UpdateOffsetted()
        Dim sec As Integer = nudSeconds.Value
        Dim msec As Integer = nudMilliseconds.Value

        Dim offset As TimeSpan = TimeSpan.FromMilliseconds(sec * 1000 + msec)

        For i As Integer = 0 To originalCaptions.Count - 1
            offsettedCaptions(i).FromTime = originalCaptions(i).FromTime + offset
            offsettedCaptions(i).ToTime = originalCaptions(i).ToTime + offset
            UpdateListViewCaption(lvOffsetted, offsettedCaptions(i))
        Next
    End Sub

    Private Sub btnClose_Click(sender As System.Object, e As System.EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub btnSave_Click(sender As System.Object, e As System.EventArgs) Handles btnSave.Click
        Me.Enabled = False

        Dim file As IO.FileInfo = New IO.FileInfo(txtSubtitlesFile.Text)
        Dim path As String = file.DirectoryName
        Dim newName As String = file.Name.Replace(file.Extension, "") + ".Offsetted" + file.Extension
        Dim newFile As String = IO.Path.Combine(path, newName)

        Dim w = New IO.StreamWriter(newFile)

        For Each c In offsettedCaptions
            w.WriteLine(c.Index)
            w.WriteLine(c.GetTime())
            w.WriteLine(c.Text)
            w.WriteLine()
        Next

        w.Close()
        Me.Enabled = True
        MsgBox("Saved Offsetted Captions to:" + vbCrLf + newFile, MsgBoxStyle.Information Or MsgBoxStyle.OkOnly)
    End Sub
End Class
