Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Friend Class frmMain
    Inherits System.Windows.Forms.Form

#Region "Windows Form Designer generated code "
	Public Sub New()
		MyBase.New()
		If m_vb6FormDefInstance Is Nothing Then
			If m_InitializingDefInstance Then
				m_vb6FormDefInstance = Me
			Else
				Try 
					'For the start-up form, the first instance created is the default instance.
					If System.Reflection.Assembly.GetExecutingAssembly.EntryPoint.DeclaringType Is Me.GetType Then
						m_vb6FormDefInstance = Me
					End If
				Catch
				End Try
			End If
		End If
        'This is required by the Windows Form Designer.
		InitializeComponent()
	End Sub
	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
		If Disposing Then
			If Not components Is Nothing Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(Disposing)
	End Sub
	'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer
    Friend WithEvents txtFileName As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents btnBrowse As System.Windows.Forms.Button
    Friend WithEvents tbPos As System.Windows.Forms.TrackBar
    Friend WithEvents btnPlay As System.Windows.Forms.Button
    Friend WithEvents btnPause As System.Windows.Forms.Button
    Friend WithEvents btnStop As System.Windows.Forms.Button
    Friend WithEvents tbVol As System.Windows.Forms.TrackBar
    Friend WithEvents tbRate As System.Windows.Forms.TrackBar
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents lblBitRate As System.Windows.Forms.Label
    Friend WithEvents lblDuration As System.Windows.Forms.Label
    Friend WithEvents btnClose As System.Windows.Forms.Button
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(frmMain))
        Me.txtFileName = New System.Windows.Forms.TextBox()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.btnBrowse = New System.Windows.Forms.Button()
        Me.btnClose = New System.Windows.Forms.Button()
        Me.tbPos = New System.Windows.Forms.TrackBar()
        Me.tbVol = New System.Windows.Forms.TrackBar()
        Me.tbRate = New System.Windows.Forms.TrackBar()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.lblBitRate = New System.Windows.Forms.Label()
        Me.lblDuration = New System.Windows.Forms.Label()
        Me.btnStop = New System.Windows.Forms.Button()
        Me.btnPause = New System.Windows.Forms.Button()
        Me.btnPlay = New System.Windows.Forms.Button()
        CType(Me.tbPos, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.tbVol, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.tbRate, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'txtFileName
        '
        Me.txtFileName.Location = New System.Drawing.Point(12, 25)
        Me.txtFileName.Name = "txtFileName"
        Me.txtFileName.ReadOnly = True
        Me.txtFileName.Size = New System.Drawing.Size(292, 21)
        Me.txtFileName.TabIndex = 0
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(12, 9)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(46, 13)
        Me.Label1.TabIndex = 1
        Me.Label1.Text = "MP3 File"
        '
        'btnBrowse
        '
        Me.btnBrowse.Location = New System.Drawing.Point(310, 25)
        Me.btnBrowse.Name = "btnBrowse"
        Me.btnBrowse.Size = New System.Drawing.Size(30, 21)
        Me.btnBrowse.TabIndex = 2
        Me.btnBrowse.Text = "..."
        Me.btnBrowse.UseVisualStyleBackColor = True
        '
        'btnClose
        '
        Me.btnClose.Location = New System.Drawing.Point(261, 275)
        Me.btnClose.Name = "btnClose"
        Me.btnClose.Size = New System.Drawing.Size(79, 29)
        Me.btnClose.TabIndex = 3
        Me.btnClose.Text = "Close"
        Me.btnClose.UseVisualStyleBackColor = True
        '
        'tbPos
        '
        Me.tbPos.Location = New System.Drawing.Point(12, 87)
        Me.tbPos.Maximum = 100
        Me.tbPos.Name = "tbPos"
        Me.tbPos.Size = New System.Drawing.Size(328, 45)
        Me.tbPos.TabIndex = 4
        Me.tbPos.TickFrequency = 5
        '
        'tbVol
        '
        Me.tbVol.Location = New System.Drawing.Point(80, 169)
        Me.tbVol.Maximum = 100
        Me.tbVol.Name = "tbVol"
        Me.tbVol.Size = New System.Drawing.Size(260, 45)
        Me.tbVol.TabIndex = 8
        Me.tbVol.TickFrequency = 5
        Me.tbVol.TickStyle = System.Windows.Forms.TickStyle.Both
        Me.tbVol.Value = 100
        '
        'tbRate
        '
        Me.tbRate.Location = New System.Drawing.Point(80, 220)
        Me.tbRate.Maximum = 200
        Me.tbRate.Name = "tbRate"
        Me.tbRate.Size = New System.Drawing.Size(260, 45)
        Me.tbRate.TabIndex = 9
        Me.tbRate.TickFrequency = 10
        Me.tbRate.TickStyle = System.Windows.Forms.TickStyle.Both
        Me.tbRate.Value = 100
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(17, 183)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(41, 13)
        Me.Label2.TabIndex = 10
        Me.Label2.Text = "Volume"
        '
        'Label3
        '
        Me.Label3.AutoSize = True
        Me.Label3.Location = New System.Drawing.Point(17, 232)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(30, 13)
        Me.Label3.TabIndex = 11
        Me.Label3.Text = "Rate"
        '
        'lblBitRate
        '
        Me.lblBitRate.AutoSize = True
        Me.lblBitRate.Location = New System.Drawing.Point(239, 49)
        Me.lblBitRate.Name = "lblBitRate"
        Me.lblBitRate.Size = New System.Drawing.Size(65, 13)
        Me.lblBitRate.TabIndex = 12
        Me.lblBitRate.Text = "BitRate: n/a"
        Me.lblBitRate.TextAlign = System.Drawing.ContentAlignment.TopRight
        '
        'lblDuration
        '
        Me.lblDuration.AutoSize = True
        Me.lblDuration.Location = New System.Drawing.Point(12, 49)
        Me.lblDuration.Name = "lblDuration"
        Me.lblDuration.Size = New System.Drawing.Size(71, 13)
        Me.lblDuration.TabIndex = 13
        Me.lblDuration.Text = "Duration: n/a"
        '
        'btnStop
        '
        Me.btnStop.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnStop.Image = Global.MP3Player.My.Resources.Resources.btnStop
        Me.btnStop.Location = New System.Drawing.Point(80, 125)
        Me.btnStop.Name = "btnStop"
        Me.btnStop.Size = New System.Drawing.Size(28, 26)
        Me.btnStop.TabIndex = 7
        Me.btnStop.UseVisualStyleBackColor = True
        '
        'btnPause
        '
        Me.btnPause.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPause.Image = Global.MP3Player.My.Resources.Resources.btnPause
        Me.btnPause.Location = New System.Drawing.Point(46, 125)
        Me.btnPause.Name = "btnPause"
        Me.btnPause.Size = New System.Drawing.Size(28, 26)
        Me.btnPause.TabIndex = 6
        Me.btnPause.UseVisualStyleBackColor = True
        '
        'btnPlay
        '
        Me.btnPlay.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPlay.Image = Global.MP3Player.My.Resources.Resources.btnPlay
        Me.btnPlay.Location = New System.Drawing.Point(12, 125)
        Me.btnPlay.Name = "btnPlay"
        Me.btnPlay.Size = New System.Drawing.Size(28, 26)
        Me.btnPlay.TabIndex = 5
        Me.btnPlay.UseVisualStyleBackColor = True
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 14)
        Me.BackColor = System.Drawing.SystemColors.Control
        Me.ClientSize = New System.Drawing.Size(352, 315)
        Me.Controls.Add(Me.lblDuration)
        Me.Controls.Add(Me.lblBitRate)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.tbRate)
        Me.Controls.Add(Me.tbVol)
        Me.Controls.Add(Me.btnStop)
        Me.Controls.Add(Me.btnPause)
        Me.Controls.Add(Me.btnPlay)
        Me.Controls.Add(Me.tbPos)
        Me.Controls.Add(Me.btnClose)
        Me.Controls.Add(Me.btnBrowse)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.txtFileName)
        Me.Cursor = System.Windows.Forms.Cursors.Default
        Me.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Location = New System.Drawing.Point(253, 415)
        Me.MaximizeBox = False
        Me.Name = "frmMain"
        Me.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "MP3Player.NET"
        CType(Me.tbPos, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.tbVol, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.tbRate, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub
#End Region

#Region "Upgrade Support "
    Private Shared m_vb6FormDefInstance As frmMain
    Private Shared m_InitializingDefInstance As Boolean
    Public Shared Property DefInstance() As frmMain
        Get
            If m_vb6FormDefInstance Is Nothing OrElse m_vb6FormDefInstance.IsDisposed Then
                m_InitializingDefInstance = True
                m_vb6FormDefInstance = New frmMain()
                m_InitializingDefInstance = False
            End If
            DefInstance = m_vb6FormDefInstance
        End Get
        Set(ByVal value As frmMain)
            m_vb6FormDefInstance = value
        End Set
    End Property
#End Region

    Private WithEvents mp3 As vbMP3decoder.CMP3Decoder

    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        Me.Close()
    End Sub

    Private Sub btnBrowse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowse.Click
        Dim ofd As Windows.Forms.OpenFileDialog = New Windows.Forms.OpenFileDialog
        With ofd
            .CheckFileExists = True
            .DefaultExt = "mp3"
            .Filter = "MP3 Files (*.mp3)|*.mp3"
            If .ShowDialog = Windows.Forms.DialogResult.OK Then
                btnPlay.Enabled = True
                btnPause.Enabled = True
                btnStop.Enabled = True
                tbVol.Enabled = True
                tbRate.Enabled = True
                tbPos.Enabled = True

                If mp3 Is Nothing Then
                    mp3 = New vbMP3decoder.CMP3Decoder(Me)
                Else
                    mp3.Stop()
                End If
                mp3.FileName = .FileName

                txtFileName.Text = IO.Path.GetFileNameWithoutExtension(.FileName)
                lblBitRate.Text = String.Format("BitRate: {0} Kbps", CInt(mp3.BitRate / 1000).ToString())

                Dim duration As TimeSpan = mp3.PosToFormattedTime(mp3.FileLength)
                lblDuration.Text = String.Format("Duration: {0}:{1}", duration.Minutes, duration.Seconds)

                mp3.Play()
            End If
        End With
    End Sub

    Private Sub frmMain_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If mp3 IsNot Nothing Then
            mp3.Stop()
            mp3.Dispose()
        End If
    End Sub

    Private Sub mp3_PositionChanged() Handles mp3.PositionChanged
        tbPos.Value = mp3.Position / mp3.FileLength * 100
    End Sub

    Private Sub mp3_DecodingProgress(ByVal progress As Single) Handles mp3.DecodingProgress
        Me.Text = progress.ToString("0") + "%"
    End Sub

    Private Sub tbPos_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbPos.Scroll
        mp3.Position = tbPos.Value / 100 * mp3.FileLength
    End Sub

    Private Sub cmdPLay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPlay.Click
        Select Case mp3.State
            Case vbMP3decoder.CMP3Decoder.DecoderStateConstants.Paused
                mp3.Pause()
            Case vbMP3decoder.CMP3Decoder.DecoderStateConstants.Playing
            Case vbMP3decoder.CMP3Decoder.DecoderStateConstants.Idle
                mp3.Play()
        End Select
    End Sub

    Private Sub btnPause_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPause.Click
        mp3.Pause()
    End Sub

    Private Sub btnStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStop.Click
        mp3.Stop()
    End Sub

    Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        btnPlay.Enabled = False
        btnPause.Enabled = False
        btnStop.Enabled = False
        tbRate.Enabled = False
        tbVol.Enabled = False
        tbPos.Enabled = False
    End Sub

    Private Sub tbVol_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbVol.Scroll
        SetRateAndVolume()
    End Sub

    Private Sub tbRate_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles tbRate.MouseDown
        If e.Button = Windows.Forms.MouseButtons.Right Then
            tbRate.Value = 100
            SetRateAndVolume()
        End If
    End Sub

    Private Sub tbRate_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbRate.Scroll
        SetRateAndVolume()
    End Sub

    Private Sub SetRateAndVolume()
        mp3.Volume = tbVol.Value
        mp3.Rate = Math.Max(tbRate.Value, 1)
    End Sub
End Class